﻿$url = 'https://s3.us-east-2.wasabisys.com/choco-packages/adobe-creative-cloud/CreativeCloud.zip' # download url
$checksum = 'C294821825509C69D227D5361D714B5BB9D5812AAE55E5D0328FD8BE03034522'
$checksumType = 'sha256'

$toolsDir = "$(Split-Path -Parent $MyInvocation.MyCommand.Definition)"
$installDir = Join-Path $toolsDir 'install'
if (!(Test-Path $installDir)) {
    New-Item -Path $InstallDir -ItemType Directory | Out-Null
}
$zipLocation = Join-Path $installDir 'CreativeCloud.zip'
$fileLocation = Join-Path $installDir 'Creative Cloud.msi'

Get-ChocolateyWebFile -PackageName $env:ChocolateyPackageName -FileFullPath $zipLocation -Url $url -Checksum $checksum -ChecksumType $checksumType
Get-ChocolateyUnzip -FileFullPath $zipLocation -Destination $installDir
Remove-Item $zipLocation
$silentArgs = '/qn' 

$packageArgs = @{
    packageName    = $env:ChocolateyPackageName
    fileType       = 'MSI'
    file           = $fileLocation
    softwareName   = 'Adobe Creative Cloud'
    silentArgs     = $silentArgs
    validExitCodes = @(0, 3010, 1641)
}

Install-ChocolateyInstallPackage @packageArgs
Remove-Item -Path $installDir -Recurse -Force
